
#ifndef GRAVATAR_EXPORT_H
#define GRAVATAR_EXPORT_H

#ifdef GRAVATAR_STATIC_DEFINE
#  define GRAVATAR_EXPORT
#  define GRAVATAR_NO_EXPORT
#else
#  ifndef GRAVATAR_EXPORT
#    ifdef KPim6Gravatar_EXPORTS
        /* We are building this library */
#      define GRAVATAR_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define GRAVATAR_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef GRAVATAR_NO_EXPORT
#    define GRAVATAR_NO_EXPORT 
#  endif
#endif

#ifndef GRAVATAR_DECL_DEPRECATED
#  define GRAVATAR_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef GRAVATAR_DECL_DEPRECATED_EXPORT
#  define GRAVATAR_DECL_DEPRECATED_EXPORT GRAVATAR_EXPORT GRAVATAR_DECL_DEPRECATED
#endif

#ifndef GRAVATAR_DECL_DEPRECATED_NO_EXPORT
#  define GRAVATAR_DECL_DEPRECATED_NO_EXPORT GRAVATAR_NO_EXPORT GRAVATAR_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef GRAVATAR_NO_DEPRECATED
#    define GRAVATAR_NO_DEPRECATED
#  endif
#endif
#include <gravatar_version.h>

#define GRAVATAR_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(GRAVATAR_NO_DEPRECATED)
#  undef GRAVATAR_DEPRECATED
#  define GRAVATAR_DEPRECATED_EXPORT GRAVATAR_EXPORT
#  define GRAVATAR_DEPRECATED_NO_EXPORT GRAVATAR_NO_EXPORT
#elif defined(GRAVATAR_NO_DEPRECATED_WARNINGS)
#  define GRAVATAR_DEPRECATED
#  define GRAVATAR_DEPRECATED_EXPORT GRAVATAR_EXPORT
#  define GRAVATAR_DEPRECATED_NO_EXPORT GRAVATAR_NO_EXPORT
#else
#  define GRAVATAR_DEPRECATED GRAVATAR_DECL_DEPRECATED
#  define GRAVATAR_DEPRECATED_EXPORT GRAVATAR_DECL_DEPRECATED_EXPORT
#  define GRAVATAR_DEPRECATED_NO_EXPORT GRAVATAR_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define GRAVATAR_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define GRAVATAR_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef GRAVATAR_NO_DEPRECATED
#  define GRAVATAR_DISABLE_DEPRECATED_BEFORE_AND_AT GRAVATAR_VERSION
#endif
#ifdef GRAVATAR_NO_DEPRECATED_WARNINGS
#  define GRAVATAR_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef GRAVATAR_DEPRECATED_WARNINGS_SINCE
#  ifdef GRAVATAR_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define GRAVATAR_DEPRECATED_WARNINGS_SINCE GRAVATAR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define GRAVATAR_DEPRECATED_WARNINGS_SINCE GRAVATAR_VERSION
#  endif
#endif

#ifndef GRAVATAR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define GRAVATAR_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef GRAVATAR_DEPRECATED
#  define GRAVATAR_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > GRAVATAR_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define GRAVATAR_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* GRAVATAR_EXPORT_H */
