
#ifndef KCALUTILS_EXPORT_H
#define KCALUTILS_EXPORT_H

#ifdef KCALUTILS_STATIC_DEFINE
#  define KCALUTILS_EXPORT
#  define KCALUTILS_NO_EXPORT
#else
#  ifndef KCALUTILS_EXPORT
#    ifdef KPim6CalendarUtils_EXPORTS
        /* We are building this library */
#      define KCALUTILS_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KCALUTILS_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KCALUTILS_NO_EXPORT
#    define KCALUTILS_NO_EXPORT 
#  endif
#endif

#ifndef KCALUTILS_DECL_DEPRECATED
#  define KCALUTILS_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KCALUTILS_DECL_DEPRECATED_EXPORT
#  define KCALUTILS_DECL_DEPRECATED_EXPORT KCALUTILS_EXPORT KCALUTILS_DECL_DEPRECATED
#endif

#ifndef KCALUTILS_DECL_DEPRECATED_NO_EXPORT
#  define KCALUTILS_DECL_DEPRECATED_NO_EXPORT KCALUTILS_NO_EXPORT KCALUTILS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KCALUTILS_NO_DEPRECATED
#    define KCALUTILS_NO_DEPRECATED
#  endif
#endif
#include <kcalutils_version.h>

#define KCALUTILS_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(KCALUTILS_NO_DEPRECATED)
#  undef KCALUTILS_DEPRECATED
#  define KCALUTILS_DEPRECATED_EXPORT KCALUTILS_EXPORT
#  define KCALUTILS_DEPRECATED_NO_EXPORT KCALUTILS_NO_EXPORT
#elif defined(KCALUTILS_NO_DEPRECATED_WARNINGS)
#  define KCALUTILS_DEPRECATED
#  define KCALUTILS_DEPRECATED_EXPORT KCALUTILS_EXPORT
#  define KCALUTILS_DEPRECATED_NO_EXPORT KCALUTILS_NO_EXPORT
#else
#  define KCALUTILS_DEPRECATED KCALUTILS_DECL_DEPRECATED
#  define KCALUTILS_DEPRECATED_EXPORT KCALUTILS_DECL_DEPRECATED_EXPORT
#  define KCALUTILS_DEPRECATED_NO_EXPORT KCALUTILS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KCALUTILS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KCALUTILS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KCALUTILS_NO_DEPRECATED
#  define KCALUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT KCALUTILS_VERSION
#endif
#ifdef KCALUTILS_NO_DEPRECATED_WARNINGS
#  define KCALUTILS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KCALUTILS_DEPRECATED_WARNINGS_SINCE
#  ifdef KCALUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KCALUTILS_DEPRECATED_WARNINGS_SINCE KCALUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KCALUTILS_DEPRECATED_WARNINGS_SINCE KCALUTILS_VERSION
#  endif
#endif

#ifndef KCALUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KCALUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KCALUTILS_DEPRECATED
#  define KCALUTILS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KCALUTILS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KCALUTILS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KCALUTILS_EXPORT_H */
