
#ifndef AKONADI_CALENDAR_EXPORT_H
#define AKONADI_CALENDAR_EXPORT_H

#ifdef AKONADI_CALENDAR_STATIC_DEFINE
#  define AKONADI_CALENDAR_EXPORT
#  define AKONADI_CALENDAR_NO_EXPORT
#else
#  ifndef AKONADI_CALENDAR_EXPORT
#    ifdef KPim6AkonadiCalendar_EXPORTS
        /* We are building this library */
#      define AKONADI_CALENDAR_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define AKONADI_CALENDAR_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef AKONADI_CALENDAR_NO_EXPORT
#    define AKONADI_CALENDAR_NO_EXPORT 
#  endif
#endif

#ifndef AKONADI_CALENDAR_DECL_DEPRECATED
#  define AKONADI_CALENDAR_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef AKONADI_CALENDAR_DECL_DEPRECATED_EXPORT
#  define AKONADI_CALENDAR_DECL_DEPRECATED_EXPORT AKONADI_CALENDAR_EXPORT AKONADI_CALENDAR_DECL_DEPRECATED
#endif

#ifndef AKONADI_CALENDAR_DECL_DEPRECATED_NO_EXPORT
#  define AKONADI_CALENDAR_DECL_DEPRECATED_NO_EXPORT AKONADI_CALENDAR_NO_EXPORT AKONADI_CALENDAR_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef AKONADI_CALENDAR_NO_DEPRECATED
#    define AKONADI_CALENDAR_NO_DEPRECATED
#  endif
#endif

#define AKONADI_CALENDAR_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(AKONADI_CALENDAR_NO_DEPRECATED)
#  undef AKONADI_CALENDAR_DEPRECATED
#  define AKONADI_CALENDAR_DEPRECATED_EXPORT AKONADI_CALENDAR_EXPORT
#  define AKONADI_CALENDAR_DEPRECATED_NO_EXPORT AKONADI_CALENDAR_NO_EXPORT
#elif defined(AKONADI_CALENDAR_NO_DEPRECATED_WARNINGS)
#  define AKONADI_CALENDAR_DEPRECATED
#  define AKONADI_CALENDAR_DEPRECATED_EXPORT AKONADI_CALENDAR_EXPORT
#  define AKONADI_CALENDAR_DEPRECATED_NO_EXPORT AKONADI_CALENDAR_NO_EXPORT
#else
#  define AKONADI_CALENDAR_DEPRECATED AKONADI_CALENDAR_DECL_DEPRECATED
#  define AKONADI_CALENDAR_DEPRECATED_EXPORT AKONADI_CALENDAR_DECL_DEPRECATED_EXPORT
#  define AKONADI_CALENDAR_DEPRECATED_NO_EXPORT AKONADI_CALENDAR_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define AKONADI_CALENDAR_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define AKONADI_CALENDAR_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef AKONADI_CALENDAR_NO_DEPRECATED
#  define AKONADI_CALENDAR_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60503
#endif
#ifdef AKONADI_CALENDAR_NO_DEPRECATED_WARNINGS
#  define AKONADI_CALENDAR_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef AKONADI_CALENDAR_DEPRECATED_WARNINGS_SINCE
#  ifdef AKONADI_CALENDAR_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define AKONADI_CALENDAR_DEPRECATED_WARNINGS_SINCE AKONADI_CALENDAR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define AKONADI_CALENDAR_DEPRECATED_WARNINGS_SINCE 0x60503
#  endif
#endif

#ifndef AKONADI_CALENDAR_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define AKONADI_CALENDAR_DISABLE_DEPRECATED_BEFORE_AND_AT 0x60000
#endif

#ifdef AKONADI_CALENDAR_DEPRECATED
#  define AKONADI_CALENDAR_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > AKONADI_CALENDAR_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define AKONADI_CALENDAR_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* AKONADI_CALENDAR_EXPORT_H */
