
#ifndef KIMAP_EXPORT_H
#define KIMAP_EXPORT_H

#ifdef KIMAP_STATIC_DEFINE
#  define KIMAP_EXPORT
#  define KIMAP_NO_EXPORT
#else
#  ifndef KIMAP_EXPORT
#    ifdef KPim6IMAP_EXPORTS
        /* We are building this library */
#      define KIMAP_EXPORT __declspec(dllexport)
#    else
        /* We are using this library */
#      define KIMAP_EXPORT __declspec(dllimport)
#    endif
#  endif

#  ifndef KIMAP_NO_EXPORT
#    define KIMAP_NO_EXPORT 
#  endif
#endif

#ifndef KIMAP_DECL_DEPRECATED
#  define KIMAP_DECL_DEPRECATED __declspec(deprecated)
#endif

#ifndef KIMAP_DECL_DEPRECATED_EXPORT
#  define KIMAP_DECL_DEPRECATED_EXPORT KIMAP_EXPORT KIMAP_DECL_DEPRECATED
#endif

#ifndef KIMAP_DECL_DEPRECATED_NO_EXPORT
#  define KIMAP_DECL_DEPRECATED_NO_EXPORT KIMAP_NO_EXPORT KIMAP_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KIMAP_NO_DEPRECATED
#    define KIMAP_NO_DEPRECATED
#  endif
#endif
#include <kimap_version.h>

#define KIMAP_DECL_DEPRECATED_TEXT(text) __declspec(deprecated(text))

#if defined(KIMAP_NO_DEPRECATED)
#  undef KIMAP_DEPRECATED
#  define KIMAP_DEPRECATED_EXPORT KIMAP_EXPORT
#  define KIMAP_DEPRECATED_NO_EXPORT KIMAP_NO_EXPORT
#elif defined(KIMAP_NO_DEPRECATED_WARNINGS)
#  define KIMAP_DEPRECATED
#  define KIMAP_DEPRECATED_EXPORT KIMAP_EXPORT
#  define KIMAP_DEPRECATED_NO_EXPORT KIMAP_NO_EXPORT
#else
#  define KIMAP_DEPRECATED KIMAP_DECL_DEPRECATED
#  define KIMAP_DEPRECATED_EXPORT KIMAP_DECL_DEPRECATED_EXPORT
#  define KIMAP_DEPRECATED_NO_EXPORT KIMAP_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KIMAP_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KIMAP_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KIMAP_NO_DEPRECATED
#  define KIMAP_DISABLE_DEPRECATED_BEFORE_AND_AT KIMAP_VERSION
#endif
#ifdef KIMAP_NO_DEPRECATED_WARNINGS
#  define KIMAP_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KIMAP_DEPRECATED_WARNINGS_SINCE
#  ifdef KIMAP_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KIMAP_DEPRECATED_WARNINGS_SINCE KIMAP_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KIMAP_DEPRECATED_WARNINGS_SINCE KIMAP_VERSION
#  endif
#endif

#ifndef KIMAP_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KIMAP_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KIMAP_DEPRECATED
#  define KIMAP_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KIMAP_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KIMAP_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KIMAP_EXPORT_H */
